import pandas as pd
import pickle
from decision_company import read_csv_file, create_dataframe, col_copy, concatenate_objects

atp_tennis = read_csv_file('atp_tennis.csv')

# Initialize an empty dictionary for the new DataFrame
player_data_dict = {'Player': [], 'Rank': [], 'Win_Loss_Ratio': [], 'Surface': [], 'Date': []}

# Create a new DataFrame with the specified columns and data
player_data = create_dataframe(player_data_dict)

# Add Player_1 data to the new DataFrame
player_data_1 = col_copy(atp_tennis, ['Player_1', 'Rank_1', 'Win_Loss_Ratio_1', 'Surface', 'Date'])
player_data_1.columns = ['Player', 'Rank', 'Win_Loss_Ratio', 'Surface', 'Date']

# Add Player_2 data to the new DataFrame
player_data_2 = col_copy(atp_tennis, ['Player_2', 'Rank_2', 'Win_Loss_Ratio_2', 'Surface', 'Date'])
player_data_2.columns = ['Player', 'Rank', 'Win_Loss_Ratio', 'Surface', 'Date']

# Concatenate Player_1 and Player_2 data
player_data = concatenate_objects(player_data_1, player_data_2)

print(player_data)
pickle.dump(player_data,open("./ref_result/player_data.pkl","wb"))